/*
 * Decompiled with CFR 0.152.
 */
package com.item_article.domain;

import com.dto.ItemArticleDto;
import com.dto.LoginDto;
import com.google.gson.Gson;
import com.item_article.data.ItemArticleDao;
import com.item_article.domain.use_case.AddCategoryToProduct;
import com.item_article.domain.use_case.CheckItemArticleErrors;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ItemArticleService {
    private final ItemArticleDao itemArticleDao;
    private final DbConnection dbConnection;
    @Resource
    @Lazy
    private AddCategoryToProduct addCategoryToProduct;
    @Resource
    @Lazy
    private CheckItemArticleErrors checkItemArticleErrors;

    public synchronized ResponseEntity<Map<String, Object>> postSmartHelpItemArticle(byte[] bodyZipped) {
        String body = ConvertStr.deCompressionGZip((byte[])bodyZipped);
        body = body.substring(19, body.length() - 1);
        Gson gson = new Gson();
        ItemArticleDto[] items = (ItemArticleDto[])gson.fromJson(body, ItemArticleDto[].class);
        return this.postSmartHelpItemArticle(Arrays.asList(items));
    }

    private ResponseEntity<Map<String, Object>> postSmartHelpItemArticle(List<ItemArticleDto> body) {
        LoginDto loginDto = this.dbConnection.setToken();
        if (!loginDto.getIsMyHoloo().booleanValue()) {
            return null;
        }
        try {
            this.itemArticleDao.bulkInsert(loginDto, body);
            return ConvertStr.getMapResponseEntity((String)"ItemArticle", null, (List)this.makeSuccessMap());
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"ItemArticle", Collections.singletonList(e.getErrorMap()), null);
        }
    }

    public ResponseEntity<Map<String, Object>> postItemArticles(List<ItemArticleDto> itemArticleList) {
        ArrayList<Map> failedList = new ArrayList<Map>();
        ArrayList<Map> successList = new ArrayList<Map>();
        LoginDto loginDto = this.dbConnection.setToken();
        for (ItemArticleDto itemArticle : itemArticleList) {
            try {
                this.checkItemArticleErrors.invoke(itemArticle, loginDto);
                successList.add(this.addCategoryToProduct.invoke(itemArticle, loginDto));
            }
            catch (TncException ex) {
                failedList.add(ex.getErrorMap());
            }
            catch (Exception ex) {
                failedList.add(TncException.fromException((Throwable)ex).getErrorMap());
            }
        }
        return ConvertStr.getMapResponseEntity((String)"productCategory", failedList, successList);
    }

    private List<Map<String, Object>> makeSuccessMap() {
        HashMap<String, Boolean> success = new HashMap<String, Boolean>();
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        success.put("Success", true);
        successList.add(success);
        return successList;
    }

    public ItemArticleService(ItemArticleDao itemArticleDao, DbConnection dbConnection) {
        this.itemArticleDao = itemArticleDao;
        this.dbConnection = dbConnection;
    }
}

